<?php
/**
 * Copyright since 2025 InPost S.A.
 *
 * For the full license information, please view the LICENSE file bundled with the module.
 *
 * @author InPost S.A.
 * @copyright since 2025 InPost S.A.
 * @license MIT
 */

declare(strict_types=1);

namespace InPost\International\Installer;

use InPost\International\Installer\Exception\InstallerException;
use Symfony\Contracts\Translation\TranslatorInterface;

if (!defined('_PS_VERSION_')) {
    exit;
}

final class HookInstaller implements InstallerInterface
{
    /**
     * @var TranslatorInterface
     */
    private $translator;

    /**
     * @var AvailableHooksProviderInterface
     */
    private $hooksProvider;

    public function __construct(TranslatorInterface $translator, AvailableHooksProviderInterface $hooksProvider)
    {
        $this->translator = $translator;
        $this->hooksProvider = $hooksProvider;
    }

    public function install(\Module $module): void
    {
        $hookNames = $this->hooksProvider->getAvailableHookNames();

        if ($module->registerHook($hookNames)) {
            return;
        }

        throw new InstallerException($this->translator->trans('Could not register hooks.', [], 'Modules.Inpostinternational.Installer'));
    }
}
