<?php
/**
 * Copyright since 2025 InPost S.A.
 *
 * For the full license information, please view the LICENSE file bundled with the module.
 *
 * @author InPost S.A.
 * @copyright since 2025 InPost S.A.
 * @license MIT
 */

declare(strict_types=1);

namespace InPost\International\Installer;

if (!defined('_PS_VERSION_')) {
    exit;
}

final class Installer implements InstallerInterface, UninstallerInterface
{
    /**
     * @var iterable<InstallerInterface>
     */
    private $installers;

    /**
     * @var iterable<UninstallerInterface>
     */
    private $uninstallers;

    /**
     * @param iterable<InstallerInterface> $installers
     * @param iterable<UninstallerInterface> $uninstallers
     */
    public function __construct(iterable $installers, iterable $uninstallers)
    {
        $this->installers = $installers;
        $this->uninstallers = $uninstallers;
    }

    public function install(\Module $module): void
    {
        foreach ($this->installers as $installer) {
            assert($installer instanceof InstallerInterface);
            $installer->install($module);
        }
    }

    public function uninstall(\Module $module, bool $keepData = true): void
    {
        foreach ($this->uninstallers as $uninstaller) {
            assert($uninstaller instanceof UninstallerInterface);
            $uninstaller->uninstall($module, $keepData);
        }
    }
}
