<?php
/**
 * Copyright since 2025 InPost S.A.
 *
 * For the full license information, please view the LICENSE file bundled with the module.
 *
 * @author InPost S.A.
 * @copyright since 2025 InPost S.A.
 * @license MIT
 */

declare(strict_types=1);

namespace InPost\International\Installer;

use InPost\International\Installer\Exception\InstallerException;
use InPost\International\Translation\Message\ImportTranslationsCommand;
use PrestaShop\PrestaShop\Core\CommandBus\CommandBusInterface;
use Symfony\Contracts\Translation\TranslatorInterface;

if (!defined('_PS_VERSION_')) {
    exit;
}

final class TranslationInstaller implements InstallerInterface
{
    /**
     * @var TranslatorInterface
     */
    private $translator;

    /**
     * @var CommandBusInterface
     */
    private $bus;

    /**
     * @var string
     */
    private $psVersion;

    public function __construct(TranslatorInterface $translator, CommandBusInterface $bus, string $psVersion = _PS_VERSION_)
    {
        $this->translator = $translator;
        $this->bus = $bus;
        $this->psVersion = $psVersion;
    }

    public function install(\Module $module): void
    {
        if (\Tools::version_compare($this->psVersion, '1.7.8', '>=')) {
            return;
        }

        $command = new ImportTranslationsCommand($module->getLocalPath() . 'translations');

        try {
            $this->bus->handle($command);
        } catch (\Exception $e) {
            throw new InstallerException($this->translator->trans('Could not import module\'s translations.', [], 'Modules.Inpostinternational.Installer'), 0, $e);
        }
    }
}
