<?php
/**
 * Copyright since 2025 InPost S.A.
 *
 * For the full license information, please view the LICENSE file bundled with the module.
 *
 * @author InPost S.A.
 * @copyright since 2025 InPost S.A.
 * @license MIT
 */

declare(strict_types=1);

namespace InPost\International\Log\Handler;

use Monolog\Handler\HandlerInterface;

if (!defined('_PS_VERSION_')) {
    exit;
}

interface HandlerFactoryInterface
{
    /**
     * @param array<string, mixed> $options
     */
    public function create(array $options): HandlerInterface;

    public function supports(string $type): bool;
}
