<?php
/**
 * Copyright since 2025 InPost S.A.
 *
 * For the full license information, please view the LICENSE file bundled with the module.
 *
 * @author InPost S.A.
 * @copyright since 2025 InPost S.A.
 * @license MIT
 */

declare(strict_types=1);

namespace InPost\International\OAuth2\Authentication;

use Psr\Http\Message\RequestInterface;

if (!defined('_PS_VERSION_')) {
    exit;
}

final class ClientSecretPost implements AuthenticationMethodInterface
{
    public const IDENTIFIER = 'client_secret_post';

    public function getIdentifier(): string
    {
        return self::IDENTIFIER;
    }

    public function authenticate(RequestInterface $request, array &$payload, ClientCredentialsInterface $credentials): RequestInterface
    {
        if (null === $secret = $credentials->getClientSecret()) {
            throw new \LogicException(sprintf('"%s" authentication method cannot be used if the client was not issued client secret.', self::IDENTIFIER));
        }

        $payload['client_id'] = $credentials->getClientId();
        $payload['client_secret'] = $secret;

        return $request;
    }
}
