<?php
/**
 * Copyright since 2025 InPost S.A.
 *
 * For the full license information, please view the LICENSE file bundled with the module.
 *
 * @author InPost S.A.
 * @copyright since 2025 InPost S.A.
 * @license MIT
 */

declare(strict_types=1);

namespace InPost\International\OAuth2\Authentication;

if (!defined('_PS_VERSION_')) {
    exit;
}

final class InMemoryCredentialsRepository implements ClientCredentialsRepositoryInterface
{
    /**
     * @var ClientCredentialsInterface|null
     */
    private $credentials;

    public function __construct(?ClientCredentialsInterface $credentials)
    {
        $this->credentials = $credentials;
    }

    public function getClientCredentials(): ?ClientCredentialsInterface
    {
        return $this->credentials;
    }
}
