<?php
/**
 * Copyright since 2025 InPost S.A.
 *
 * For the full license information, please view the LICENSE file bundled with the module.
 *
 * @author InPost S.A.
 * @copyright since 2025 InPost S.A.
 * @license MIT
 */

declare(strict_types=1);

namespace InPost\International\OAuth2;

use InPost\International\OAuth2\Authentication\ClientCredentialsInterface;
use InPost\International\OAuth2\Token\AccessTokenRepositoryInterface;

if (!defined('_PS_VERSION_')) {
    exit;
}

interface AuthorizationProviderFactoryInterface
{
    public function create(UriCollectionInterface $uriCollection, ClientCredentialsInterface $credentials, AccessTokenRepositoryInterface $tokenRepository = null): AuthorizationProviderInterface;
}
