<?php
/**
 * Copyright since 2025 InPost S.A.
 *
 * For the full license information, please view the LICENSE file bundled with the module.
 *
 * @author InPost S.A.
 * @copyright since 2025 InPost S.A.
 * @license MIT
 */

declare(strict_types=1);

namespace InPost\International\OAuth2;

use InPost\International\OAuth2\Token\AccessTokenInterface;
use Symfony\Component\HttpFoundation\Request;

if (!defined('_PS_VERSION_')) {
    exit;
}

interface AuthorizationProviderInterface
{
    /**
     * @param string[] $scopes scopes to request
     */
    public function authorize(array $scopes = []): void;

    /**
     * Retrieves authorization response data for later usage by @see self::getAccessToken()
     */
    public function processAuthorizationResponse(Request $request): void;

    /**
     * @param string[] $scopes scopes to request
     */
    public function getAccessToken(bool $renew = false, array $scopes = []): AccessTokenInterface;
}
