<?php
/**
 * Copyright since 2025 InPost S.A.
 *
 * For the full license information, please view the LICENSE file bundled with the module.
 *
 * @author InPost S.A.
 * @copyright since 2025 InPost S.A.
 * @license MIT
 */

declare(strict_types=1);

namespace InPost\International\OAuth2;

use InPost\International\OAuth2\Authentication\ClientCredentialsInterface;

if (!defined('_PS_VERSION_')) {
    exit;
}

interface AuthorizationServerClientInterface
{
    /**
     * @param array<string, mixed> $parameters request parameters
     *
     * @return array<string, mixed> decoded access token response
     */
    public function sendAccessTokenRequest(ClientCredentialsInterface $credentials, array $parameters): array;

    /**
     * @param array<string, mixed> $parameters query parameters
     *
     * @return void
     */
    public function redirectToAuthorizationEndpoint(array $parameters): void;
}
