<?php
/**
 * Copyright since 2025 InPost S.A.
 *
 * For the full license information, please view the LICENSE file bundled with the module.
 *
 * @author InPost S.A.
 * @copyright since 2025 InPost S.A.
 * @license MIT
 */

declare(strict_types=1);

namespace InPost\International\OAuth2\Exception;

if (!defined('_PS_VERSION_')) {
    exit;
}

final class AuthorizationRequestException extends RuntimeException
{
    /**
     * @var string
     */
    private $error;

    /**
     * @var string|null
     */
    private $description;

    public function __construct(string $error, string $description = null, string $message = '', int $code = 0)
    {
        parent::__construct($message, $code);

        $this->error = $error;
        $this->description = $description;
    }

    public static function create(array $data): self
    {
        $error = $data['error'];
        $description = $data['error_description'] ?? null;

        $message = sprintf('Authorization request error: "%s".', $error);
        if (null !== $description) {
            $message = sprintf('%s Description: "%s".', $message, $description);
        }

        return new self($error, $description, $message);
    }

    public function getError(): string
    {
        return $this->error;
    }

    public function getErrorDescription(): ?string
    {
        return $this->description;
    }
}
