<?php
/**
 * Copyright since 2025 InPost S.A.
 *
 * For the full license information, please view the LICENSE file bundled with the module.
 *
 * @author InPost S.A.
 * @copyright since 2025 InPost S.A.
 * @license MIT
 */

declare(strict_types=1);

namespace InPost\International\OAuth2\Grant;

use InPost\International\OAuth2\Authentication\ClientCredentialsInterface;
use InPost\International\OAuth2\AuthorizationServerClientInterface;
use Symfony\Component\HttpFoundation\Request;

if (!defined('_PS_VERSION_')) {
    exit;
}

abstract class AbstractGrant implements GrantTypeInterface
{
    /**
     * {@inheritDoc}
     */
    public function authorize(AuthorizationServerClientInterface $authServerClient, ClientCredentialsInterface $credentials, array $scopes = [])
    {
    }

    /**
     * {@inheritDoc}
     */
    public function processAuthorizationResponse(Request $request): void
    {
    }

    /**
     * {@inheritDoc}
     */
    public function getAccessToken(AuthorizationServerClientInterface $authServerClient, ClientCredentialsInterface $credentials, array $scopes = []): array
    {
        $params = $this->getAccessTokenRequestParameters($credentials, $scopes);

        return $authServerClient->sendAccessTokenRequest($credentials, $params);
    }

    protected function getAccessTokenRequestParameters(ClientCredentialsInterface $credentials, array $scopes): array
    {
        $params = ['grant_type' => $this->getIdentifier()];
        if ([] !== $scopes) {
            $params['scope'] = implode(' ', $scopes);
        }

        return $params;
    }
}
