<?php
/**
 * Copyright since 2025 InPost S.A.
 *
 * For the full license information, please view the LICENSE file bundled with the module.
 *
 * @author InPost S.A.
 * @copyright since 2025 InPost S.A.
 * @license MIT
 */

declare(strict_types=1);

namespace InPost\International\OAuth2\Grant;

use InPost\International\OAuth2\Authentication\ClientCredentialsInterface;
use InPost\International\OAuth2\AuthorizationServerClientInterface;
use Symfony\Component\HttpFoundation\Request;

if (!defined('_PS_VERSION_')) {
    exit;
}

interface GrantTypeInterface
{
    public function getIdentifier(): string;

    /**
     * @param string[] $scopes requested scopes
     *
     * @return void
     */
    public function authorize(AuthorizationServerClientInterface $authServerClient, ClientCredentialsInterface $credentials, array $scopes = []);

    /**
     * Retrieves authorization response data for later usage by @see self::getAccessToken()
     */
    public function processAuthorizationResponse(Request $request): void;

    /**
     * @param string[] $scopes requested scopes
     *
     * @return array decoded access token response data
     */
    public function getAccessToken(AuthorizationServerClientInterface $authServerClient, ClientCredentialsInterface $credentials, array $scopes = []): array;
}
