<?php
/**
 * Copyright since 2025 InPost S.A.
 *
 * For the full license information, please view the LICENSE file bundled with the module.
 *
 * @author InPost S.A.
 * @copyright since 2025 InPost S.A.
 * @license MIT
 */

declare(strict_types=1);

namespace InPost\International\OAuth2\Grant;

use InPost\International\OAuth2\Authentication\ClientCredentialsInterface;

if (!defined('_PS_VERSION_')) {
    exit;
}

/**
 * @internal
 */
final class RefreshTokenGrant extends AbstractGrant
{
    public const IDENTIFIER = 'refresh_token';

    /**
     * @var string
     */
    private $refreshToken;

    public function __construct(string $refreshToken)
    {
        $this->refreshToken = $refreshToken;
    }

    public function getIdentifier(): string
    {
        return self::IDENTIFIER;
    }

    protected function getAccessTokenRequestParameters(ClientCredentialsInterface $credentials, array $scopes): array
    {
        $params = parent::getAccessTokenRequestParameters($credentials, $scopes);
        $params['refresh_token'] = $this->refreshToken;

        return $params;
    }
}
