<?php
/**
 * Copyright since 2025 InPost S.A.
 *
 * For the full license information, please view the LICENSE file bundled with the module.
 *
 * @author InPost S.A.
 * @copyright since 2025 InPost S.A.
 * @license MIT
 */

declare(strict_types=1);

namespace InPost\International\OAuth2\PKCE;

if (!defined('_PS_VERSION_')) {
    exit;
}

abstract class PkceMethod implements PkceMethodInterface
{
    /**
     * @var string|null
     */
    private $codeVerifier;

    public function getCodeVerifier(): string
    {
        return $this->codeVerifier ?? $this->codeVerifier = $this->generateCodeVerifier();
    }

    protected static function base64UrlEncode(string $data): string
    {
        return rtrim(strtr(base64_encode($data), '+/', '-_'), '=');
    }

    private function generateCodeVerifier(): string
    {
        return self::base64UrlEncode(random_bytes(64));
    }
}
