<?php
/**
 * Copyright since 2025 InPost S.A.
 *
 * For the full license information, please view the LICENSE file bundled with the module.
 *
 * @author InPost S.A.
 * @copyright since 2025 InPost S.A.
 * @license MIT
 */

declare(strict_types=1);

namespace InPost\International\OAuth2\PKCE;

if (!defined('_PS_VERSION_')) {
    exit;
}

class S256PkceMethod extends PkceMethod
{
    public const IDENTIFIER = 'S256';

    public function getIdentifier(): string
    {
        return self::IDENTIFIER;
    }

    public function getCodeChallenge(): string
    {
        $codeVerifier = $this->getCodeVerifier();

        return self::base64UrlEncode(hash('sha256', $codeVerifier, true));
    }
}
