<?php
/**
 * Copyright since 2025 InPost S.A.
 *
 * For the full license information, please view the LICENSE file bundled with the module.
 *
 * @author InPost S.A.
 * @copyright since 2025 InPost S.A.
 * @license MIT
 */

declare(strict_types=1);

namespace InPost\International\OAuth2\Redirection;

if (!defined('_PS_VERSION_')) {
    exit;
}

final class RedirectionHandler implements RedirectionHandlerInterface
{
    /**
     * {@inheritDoc}
     */
    public function redirect(string $url): void
    {
        header('Location: ' . $url);
        exit;
    }
}
