<?php
/**
 * Copyright since 2025 InPost S.A.
 *
 * For the full license information, please view the LICENSE file bundled with the module.
 *
 * @author InPost S.A.
 * @copyright since 2025 InPost S.A.
 * @license MIT
 */

declare(strict_types=1);

namespace InPost\International\OAuth2\Token;

use Psr\Http\Message\RequestInterface;

if (!defined('_PS_VERSION_')) {
    exit;
}

interface AccessTokenInterface
{
    public function getAccessToken(): string;

    public function getType(): string;

    public function getExpiresAt(): ?\DateTimeImmutable;

    public function getRefreshToken(): ?string;

    /**
     * @return string[]|null
     */
    public function getScopes(): ?array;

    public function authorize(RequestInterface $request): RequestInterface;
}
