<?php
/**
 * Copyright since 2025 InPost S.A.
 *
 * For the full license information, please view the LICENSE file bundled with the module.
 *
 * @author InPost S.A.
 * @copyright since 2025 InPost S.A.
 * @license MIT
 */

declare(strict_types=1);

namespace InPost\International\OAuth2\Token;

if (!defined('_PS_VERSION_')) {
    exit;
}

interface AccessTokenRepositoryInterface
{
    public function getAccessToken(): ?AccessTokenInterface;

    public function saveAccessToken(AccessTokenInterface $accessToken): void;

    public function deleteAccessToken(): void;
}
