<?php
/**
 * Copyright since 2025 InPost S.A.
 *
 * For the full license information, please view the LICENSE file bundled with the module.
 *
 * @author InPost S.A.
 * @copyright since 2025 InPost S.A.
 * @license MIT
 */

declare(strict_types=1);

namespace InPost\International\OAuth2\Token;

if (!defined('_PS_VERSION_')) {
    exit;
}

/**
 * @mixin AccessTokenInterface
 */
trait AccessTokenTrait
{
    /**
     * @var string
     */
    private $accessToken;

    /**
     * @var \DateTimeImmutable|null
     */
    private $expiresAt;

    /**
     * @var string|null
     */
    private $refreshToken;

    /**
     * @var string[]|null
     */
    private $scopes;

    public function getAccessToken(): string
    {
        return $this->accessToken;
    }

    public function getExpiresAt(): ?\DateTimeImmutable
    {
        return $this->expiresAt;
    }

    public function getRefreshToken(): ?string
    {
        return $this->refreshToken;
    }

    public function getScopes(): ?array
    {
        return $this->scopes;
    }
}
