<?php
/**
 * Copyright since 2025 InPost S.A.
 *
 * For the full license information, please view the LICENSE file bundled with the module.
 *
 * @author InPost S.A.
 * @copyright since 2025 InPost S.A.
 * @license MIT
 */

declare(strict_types=1);

namespace InPost\International\OAuth2\Token;

use Psr\Http\Message\RequestInterface;

if (!defined('_PS_VERSION_')) {
    exit;
}

final class BearerToken implements AccessTokenInterface
{
    use AccessTokenTrait;

    public const TYPE = 'bearer';

    /**
     * @param string[]|null $scopes
     */
    public function __construct(string $accessToken, \DateTimeImmutable $expiresAt = null, string $refreshToken = null, array $scopes = null)
    {
        $this->accessToken = $accessToken;
        $this->expiresAt = $expiresAt;
        $this->refreshToken = $refreshToken;
        $this->scopes = $scopes;
    }

    public function getType(): string
    {
        return self::TYPE;
    }

    public function authorize(RequestInterface $request): RequestInterface
    {
        return $request->withHeader('Authorization', 'Bearer ' . $this->accessToken);
    }
}
