<?php
/**
 * Copyright since 2025 InPost S.A.
 *
 * For the full license information, please view the LICENSE file bundled with the module.
 *
 * @author InPost S.A.
 * @copyright since 2025 InPost S.A.
 * @license MIT
 */

declare(strict_types=1);

namespace InPost\International\OAuth2\Token;

use InPost\International\OAuth2\Exception\UnexpectedValueException;

if (!defined('_PS_VERSION_')) {
    exit;
}

final class BearerTokenFactory implements AccessTokenFactoryInterface
{
    use AccessTokenFactoryTrait;

    public function createToken(array $data): AccessTokenInterface
    {
        if (0 !== strcasecmp(BearerToken::TYPE, $data['token_type'])) {
            throw new UnexpectedValueException(sprintf('Expected token type to be "%s", "%s" given.', BearerToken::TYPE, $data['token_type']));
        }

        return new BearerToken(
            $data['access_token'],
            $this->getExpiresAt($data),
            $data['refresh_token'] ?? null,
            $this->getScopes($data)
        );
    }
}
