<?php
/**
 * Copyright since 2025 InPost S.A.
 *
 * For the full license information, please view the LICENSE file bundled with the module.
 *
 * @author InPost S.A.
 * @copyright since 2025 InPost S.A.
 * @license MIT
 */

declare(strict_types=1);

namespace InPost\International\OAuth2\Token;

if (!defined('_PS_VERSION_')) {
    exit;
}

final class InMemoryTokenRepository implements AccessTokenRepositoryInterface
{
    /**
     * @var AccessTokenInterface|null
     */
    private $accessToken;

    public function getAccessToken(): ?AccessTokenInterface
    {
        return $this->accessToken;
    }

    public function saveAccessToken(AccessTokenInterface $accessToken): void
    {
        $this->accessToken = $accessToken;
    }

    public function deleteAccessToken(): void
    {
        $this->accessToken = null;
    }
}
