<?php
/**
 * Copyright since 2025 InPost S.A.
 *
 * For the full license information, please view the LICENSE file bundled with the module.
 *
 * @author InPost S.A.
 * @copyright since 2025 InPost S.A.
 * @license MIT
 */

declare(strict_types=1);

namespace InPost\International\OAuth2;

if (!defined('_PS_VERSION_')) {
    exit;
}

final class UriCollection implements UriCollectionInterface
{
    /**
     * @var string
     */
    private $authEndpointUri;

    /**
     * @var string
     */
    private $tokenEndpointUri;

    public function __construct(string $authEndpointUri, string $tokenEndpointUri)
    {
        $this->authEndpointUri = $authEndpointUri;
        $this->tokenEndpointUri = $tokenEndpointUri;
    }

    public function getAuthorizationEndpointUri(): string
    {
        return $this->authEndpointUri;
    }

    public function getTokenEndpointUri(): string
    {
        return $this->tokenEndpointUri;
    }
}
