<?php
/**
 * Copyright since 2025 InPost S.A.
 *
 * For the full license information, please view the LICENSE file bundled with the module.
 *
 * @author InPost S.A.
 * @copyright since 2025 InPost S.A.
 * @license MIT
 */

declare(strict_types=1);

namespace InPost\International\Order\Event\Admin;

use InPost\International\Hook\Event\AbstractActionHook;
use PrestaShop\PrestaShop\Core\Grid\Definition\GridDefinitionInterface;
use Symfony\Component\HttpFoundation\Request;

if (!defined('_PS_VERSION_')) {
    exit;
}

final class BuildGridDefinitionEvent extends AbstractActionHook
{
    public const NAME = 'actionOrderGridDefinitionModifier';

    /**
     * @var GridDefinitionInterface
     */
    private $definition;

    /**
     * @var string
     */
    private $psVersion;

    public function __construct(GridDefinitionInterface $definition, Request $request = null, string $_ps_version = _PS_VERSION_)
    {
        $this->definition = $definition;
        $this->request = $request;
        $this->psVersion = $_ps_version;
    }

    public function getName(): string
    {
        return self::NAME;
    }

    public function getDefinition(): GridDefinitionInterface
    {
        return $this->definition;
    }

    public function getPrestaShopVersion(): string
    {
        return $this->psVersion;
    }
}
