<?php
/**
 * Copyright since 2025 InPost S.A.
 *
 * For the full license information, please view the LICENSE file bundled with the module.
 *
 * @author InPost S.A.
 * @copyright since 2025 InPost S.A.
 * @license MIT
 */

declare(strict_types=1);

namespace InPost\International\Order\Event\Admin;

use Doctrine\DBAL\Query\QueryBuilder;
use InPost\International\Hook\Event\AbstractActionHook;
use PrestaShop\PrestaShop\Core\Grid\Search\SearchCriteriaInterface;
use Symfony\Component\HttpFoundation\Request;

if (!defined('_PS_VERSION_')) {
    exit;
}

final class BuildOrdersQueriesEvent extends AbstractActionHook
{
    public const NAME = 'actionOrderGridQueryBuilderModifier';

    /**
     * @var QueryBuilder
     */
    private $searchQueryBuilder;

    /**
     * @var QueryBuilder
     */
    private $countQueryBuilder;

    /**
     * @var SearchCriteriaInterface
     */
    private $searchCriteria;

    public function __construct(QueryBuilder $search_query_builder, QueryBuilder $count_query_builder, SearchCriteriaInterface $search_criteria, Request $request = null)
    {
        $this->searchQueryBuilder = $search_query_builder;
        $this->countQueryBuilder = $count_query_builder;
        $this->searchCriteria = $search_criteria;
        $this->request = $request;
    }

    public function getName(): string
    {
        return self::NAME;
    }

    public function getSearchQueryBuilder(): QueryBuilder
    {
        return $this->searchQueryBuilder;
    }

    public function getCountQueryBuilder(): QueryBuilder
    {
        return $this->countQueryBuilder;
    }

    public function getSearchCriteria(): SearchCriteriaInterface
    {
        return $this->searchCriteria;
    }
}
