<?php
/**
 * Copyright since 2025 InPost S.A.
 *
 * For the full license information, please view the LICENSE file bundled with the module.
 *
 * @author InPost S.A.
 * @copyright since 2025 InPost S.A.
 * @license MIT
 */

declare(strict_types=1);

namespace InPost\International\Order\Event\Admin;

use InPost\International\Hook\Event\AbstractDisplayHook;
use Symfony\Component\HttpFoundation\Request;

if (!defined('_PS_VERSION_')) {
    exit;
}

final class DisplayOrderTabLinkEvent extends AbstractDisplayHook
{
    public const NAME = 'displayAdminOrderTabLink';

    /**
     * @var int
     */
    private $orderId;

    public function __construct(int $id_order, Request $request = null)
    {
        $this->orderId = $id_order;
        $this->request = $request;
    }

    public function getName(): string
    {
        return self::NAME;
    }

    public function getOrderId(): int
    {
        return $this->orderId;
    }
}
