<?php
/**
 * Copyright since 2025 InPost S.A.
 *
 * For the full license information, please view the LICENSE file bundled with the module.
 *
 * @author InPost S.A.
 * @copyright since 2025 InPost S.A.
 * @license MIT
 */

declare(strict_types=1);

namespace InPost\International\Order\Event;

use InPost\International\Hook\Event\AbstractDisplayHook;
use Symfony\Component\HttpFoundation\Request;

if (!defined('_PS_VERSION_')) {
    exit;
}

final class DisplayOrderConfirmationEvent extends AbstractDisplayHook
{
    public const NAME = 'displayOrderConfirmation';

    /**
     * @var \Order
     */
    private $order;

    public function __construct(\Order $order, Request $request = null)
    {
        $this->order = $order;
        $this->request = $request;
    }

    public function getName(): string
    {
        return self::NAME;
    }

    public function getOrder(): \Order
    {
        return $this->order;
    }
}
