<?php
/**
 * Copyright since 2025 InPost S.A.
 *
 * For the full license information, please view the LICENSE file bundled with the module.
 *
 * @author InPost S.A.
 * @copyright since 2025 InPost S.A.
 * @license MIT
 */

declare(strict_types=1);

namespace InPost\International\Order\EventListener;

use InPost\International\Order\Event\DisplayOrderConfirmationEvent;
use InPost\International\Order\Event\DisplayOrderDetailsEvent;
use InPost\International\Order\View\DeliveryPointViewFactory;
use InPost\International\Templating\RendererInterface;
use Symfony\Component\EventDispatcher\EventSubscriberInterface;

if (!defined('_PS_VERSION_')) {
    exit;
}

final class DisplayDeliveryDetailsListener implements EventSubscriberInterface
{
    /**
     * @var DeliveryPointViewFactory
     */
    private $viewFactory;

    /**
     * @var RendererInterface
     */
    private $renderer;

    public function __construct(DeliveryPointViewFactory $viewFactory, RendererInterface $renderer)
    {
        $this->viewFactory = $viewFactory;
        $this->renderer = $renderer;
    }

    public static function getSubscribedEvents(): array
    {
        return [
            DisplayOrderConfirmationEvent::NAME => 'onDisplayOrderConfirmation',
            DisplayOrderDetailsEvent::NAME => 'onDisplayOrderDetails',
        ];
    }

    public function onDisplayOrderConfirmation(DisplayOrderConfirmationEvent $event): void
    {
        if (null === $view = $this->viewFactory->getView($event->getOrder())) {
            return;
        }

        $content = $this->renderer->render('module:inpostinternational/views/templates/hook/order_confirmation/delivery_details.tpl', [
            'pickup_point' => $view,
        ]);

        $event->appendContent($content);
    }

    public function onDisplayOrderDetails(DisplayOrderDetailsEvent $event): void
    {
        if (null === $view = $this->viewFactory->getView($event->getOrder())) {
            return;
        }

        $content = $this->renderer->render('module:inpostinternational/views/templates/hook/order_details/delivery_details.tpl', [
            'pickup_point' => $view,
        ]);

        $event->appendContent($content);
    }
}
