<?php
/**
 * Copyright since 2025 InPost S.A.
 *
 * For the full license information, please view the LICENSE file bundled with the module.
 *
 * @author InPost S.A.
 * @copyright since 2025 InPost S.A.
 * @license MIT
 */

declare(strict_types=1);

namespace InPost\International\Order\View\Model;

if (!defined('_PS_VERSION_')) {
    exit;
}

/**
 * @implements \ArrayAccess<string, string>
 */
final class DeliveryPointView implements \ArrayAccess
{
    /**
     * @var string
     */
    private $name;

    /**
     * @var string
     */
    private $formattedAddress;

    public function __construct(string $name)
    {
        $this->name = $name;
    }

    public function getName(): string
    {
        return $this->name;
    }

    public function getFormattedAddress(): ?string
    {
        return $this->formattedAddress;
    }

    public function setFormattedAddress(string $formattedAddress): void
    {
        $this->formattedAddress = $formattedAddress;
    }

    public function offsetExists($offset): bool
    {
        return in_array($offset, [
            'name',
            'formatted_address',
        ]);
    }

    public function offsetGet($offset): string
    {
        switch ($offset) {
            case 'name':
                return $this->name;
            case 'formatted_address':
                return $this->formattedAddress;
            default:
                throw new \OutOfRangeException(sprintf('Undefined index "%s".', $offset));
        }
    }

    public function offsetSet($offset, $value): void
    {
        throw new \BadMethodCallException('Not supported.');
    }

    public function offsetUnset($offset): void
    {
        throw new \BadMethodCallException('Not supported.');
    }
}
