<?php
/**
 * Copyright since 2025 InPost S.A.
 *
 * For the full license information, please view the LICENSE file bundled with the module.
 *
 * @author InPost S.A.
 * @copyright since 2025 InPost S.A.
 * @license MIT
 */

declare(strict_types=1);

namespace InPost\International\ParcelTemplate;

use InPost\International\Api\Shipment\Model\Parcel\DimensionUnit;
use InPost\International\Api\Shipment\Model\Parcel\WeightUnit;
use InPost\International\Entity\Dimensions;
use InPost\International\Entity\Weight;
use InPost\International\Shipment\DTO\Dimensions as DimensionsDto;
use InPost\International\Shipment\DTO\Weight as WeightDto;

if (!defined('_PS_VERSION_')) {
    exit;
}

final class DimensionsMapper
{
    public function mapDtoToDimensions(DimensionsDto $dimensions): Dimensions
    {
        return new Dimensions(
            (float) $dimensions->getLength(),
            (float) $dimensions->getWidth(),
            (float) $dimensions->getHeight(),
            $dimensions->getUnit() ?? DimensionUnit::getDefault()
        );
    }

    public function mapDtoToWeight(WeightDto $weight): Weight
    {
        return new Weight(
            (float) $weight->getAmount(),
            $weight->getUnit() ?? WeightUnit::getDefault()
        );
    }
}
