<?php
/**
 * Copyright since 2025 InPost S.A.
 *
 * For the full license information, please view the LICENSE file bundled with the module.
 *
 * @author InPost S.A.
 * @copyright since 2025 InPost S.A.
 * @license MIT
 */

declare(strict_types=1);

namespace InPost\International\ParcelTemplate\Form\Type;

use InPost\International\Api\Shipment\Model\Parcel\ParcelType;
use InPost\International\Enum\Form\Type\EnumType;
use InPost\International\ParcelTemplate\Message\CreateParcelTemplateCommand;
use InPost\International\ParcelTemplate\Message\EditParcelTemplateCommand;
use InPost\International\Shipment\Form\Type\DimensionsType;
use InPost\International\Shipment\Form\Type\WeightType;
use PrestaShopBundle\Form\Admin\Type\SwitchType;
use Symfony\Component\Form\AbstractType;
use Symfony\Component\Form\Extension\Core\Type\TextType;
use Symfony\Component\Form\FormBuilderInterface;
use Symfony\Component\Form\FormEvent;
use Symfony\Component\Form\FormEvents;
use Symfony\Component\OptionsResolver\OptionsResolver;
use Symfony\Contracts\Translation\TranslatorInterface;

if (!defined('_PS_VERSION_')) {
    exit;
}

final class ParcelTemplateType extends AbstractType
{
    /**
     * @var TranslatorInterface
     */
    private $translator;

    public function __construct(TranslatorInterface $translator)
    {
        $this->translator = $translator;
    }

    public function buildForm(FormBuilderInterface $builder, array $options): void
    {
        $builder
            ->add('default', SwitchType::class, [
                'label' => $this->translator->trans('Default', [], 'Modules.Inpostinternational.Admin'),
            ])
            ->add('name', TextType::class, [
                'label' => $this->translator->trans('Name', [], 'Admin.Global'),
            ])
            ->add('type', EnumType::class, [
                'class' => ParcelType::class,
                'label' => $this->translator->trans('Parcel type', [], 'Modules.Inpostinternational.Shipment'),
            ])
            ->add('dimensions', DimensionsType::class, [
                'label' => $this->translator->trans('Dimensions', [], 'Modules.Inpostinternational.Shipment'),
            ])
            ->add('weight', WeightType::class, [
                'label' => $this->translator->trans('Weight', [], 'Admin.Global'),
            ]);

        if (EditParcelTemplateCommand::class !== $options['data_class']) {
            return;
        }

        $builder->addEventListener(FormEvents::PRE_SET_DATA, function (FormEvent $event) {
            $data = $event->getData();

            if (!$data instanceof EditParcelTemplateCommand || !$data->isDefault()) {
                return;
            }

            $event->getForm()->add('default', SwitchType::class, [
                'label' => $this->translator->trans('Default', [], 'Modules.Inpostinternational.Admin'),
                'disabled' => true,
            ]);
        });
    }

    public function configureOptions(OptionsResolver $resolver): void
    {
        $resolver->setDefaults([
            'data_class' => CreateParcelTemplateCommand::class,
        ]);
    }
}
