<?php
/**
 * Copyright since 2025 InPost S.A.
 *
 * For the full license information, please view the LICENSE file bundled with the module.
 *
 * @author InPost S.A.
 * @copyright since 2025 InPost S.A.
 * @license MIT
 */

declare(strict_types=1);

namespace InPost\International\ParcelTemplate\Message;

use InPost\International\Api\Shipment\Model\Parcel\ParcelType;
use InPost\International\Shipment\DTO\Dimensions;
use InPost\International\Shipment\DTO\Weight;
use Symfony\Component\Validator\Constraints as Assert;

if (!defined('_PS_VERSION_')) {
    exit;
}

final class CreateParcelTemplateCommand
{
    /**
     * @var string|null
     *
     * @Assert\NotBlank
     * @Assert\Length(max=64)
     */
    private $name;

    /**
     * @var ParcelType|null
     *
     * @Assert\NotNull
     */
    private $type;

    /**
     * @var Dimensions|null
     *
     * @Assert\NotNull
     * @Assert\Valid
     */
    private $dimensions;

    /**
     * @var Weight|null
     *
     * @Assert\NotNull
     * @Assert\Valid
     */
    private $weight;

    /**
     * @var bool|null
     *
     * @Assert\NotNull
     */
    private $default = false;

    public function __construct()
    {
        $this->dimensions = new Dimensions();
        $this->weight = new Weight();
    }

    public function getName(): ?string
    {
        return $this->name;
    }

    public function setName(?string $name): void
    {
        $this->name = $name;
    }

    public function getType(): ?ParcelType
    {
        return $this->type;
    }

    public function setType(?ParcelType $type): void
    {
        $this->type = $type;
    }

    public function getDimensions(): ?Dimensions
    {
        return $this->dimensions;
    }

    public function setDimensions(?Dimensions $dimensions): void
    {
        $this->dimensions = $dimensions;
    }

    public function getWeight(): ?Weight
    {
        return $this->weight;
    }

    public function setWeight(?Weight $weight): void
    {
        $this->weight = $weight;
    }

    public function isDefault(): ?bool
    {
        return $this->default;
    }

    public function setDefault(?bool $default): void
    {
        $this->default = $default;
    }
}
