<?php
/**
 * Copyright since 2025 InPost S.A.
 *
 * For the full license information, please view the LICENSE file bundled with the module.
 *
 * @author InPost S.A.
 * @copyright since 2025 InPost S.A.
 * @license MIT
 */

declare(strict_types=1);

namespace InPost\International\ParcelTemplate\Message;

if (!defined('_PS_VERSION_')) {
    exit;
}

final class SelectDefaultParcelTemplateCommand
{
    /**
     * @var int
     */
    private $templateId;

    public function __construct(int $templateId)
    {
        $this->templateId = $templateId;
    }

    public function getTemplateId(): int
    {
        return $this->templateId;
    }
}
