<?php
/**
 * Copyright since 2025 InPost S.A.
 *
 * For the full license information, please view the LICENSE file bundled with the module.
 *
 * @author InPost S.A.
 * @copyright since 2025 InPost S.A.
 * @license MIT
 */

declare(strict_types=1);

namespace InPost\International\ParcelTemplate;

use Doctrine\Common\Collections\Selectable;
use Doctrine\Persistence\ObjectRepository;
use InPost\International\Entity\ParcelTemplate;

if (!defined('_PS_VERSION_')) {
    exit;
}

/**
 * @extends ObjectRepository<ParcelTemplate>
 * @extends Selectable<int, ParcelTemplate>
 */
interface ParcelTemplateRepositoryInterface extends ObjectRepository, Selectable
{
    public function add(ParcelTemplate $template): void;

    public function remove(ParcelTemplate $template): void;

    public function getDefault(): ?ParcelTemplate;
}
