<?php
/**
 * Copyright since 2025 InPost S.A.
 *
 * For the full license information, please view the LICENSE file bundled with the module.
 *
 * @author InPost S.A.
 * @copyright since 2025 InPost S.A.
 * @license MIT
 */

declare(strict_types=1);

namespace InPost\International\PickupAddress\Form\Type;

use InPost\International\Country;
use InPost\International\Enum\Form\Type\EnumType;
use InPost\International\PickupAddress\DTO\Address;
use Symfony\Component\Form\AbstractType;
use Symfony\Component\Form\Extension\Core\Type\TextareaType;
use Symfony\Component\Form\Extension\Core\Type\TextType;
use Symfony\Component\Form\FormBuilderInterface;
use Symfony\Component\OptionsResolver\OptionsResolver;
use Symfony\Contracts\Translation\TranslatorInterface;

if (!defined('_PS_VERSION_')) {
    exit;
}

final class AddressType extends AbstractType
{
    /**
     * @var TranslatorInterface
     */
    private $translator;

    public function __construct(TranslatorInterface $translator)
    {
        $this->translator = $translator;
    }

    public function buildForm(FormBuilderInterface $builder, array $options): void
    {
        $builder
            ->add('street', TextType::class, [
                'label' => $this->translator->trans('Street', [], 'Modules.Inpostinternational.Address'),
            ])
            ->add('houseNumber', TextType::class, [
                'label' => $this->translator->trans('House number', [], 'Modules.Inpostinternational.Address'),
            ])
            ->add('flatNumber', TextType::class, [
                'required' => false,
                'label' => $this->translator->trans('Flat number', [], 'Modules.Inpostinternational.Address'),
            ])
            ->add('postcode', TextType::class, [
                'label' => $this->translator->trans('Zip/Postal code', [], 'Admin.Global'),
            ])
            ->add('city', TextType::class, [
                'label' => $this->translator->trans('City', [], 'Admin.Global'),
            ])
            ->add('country', EnumType::class, [
                'class' => Country::class,
                'choices' => [Country::Poland()],
                'label' => $this->translator->trans('Country', [], 'Admin.Global'),
            ])
            ->add('description', TextareaType::class, [
                'required' => false,
                'label' => $this->translator->trans('Description', [], 'Admin.Global'),
            ]);
    }

    public function configureOptions(OptionsResolver $resolver): void
    {
        $resolver->setDefaults([
            'data_class' => Address::class,
        ]);
    }
}
