<?php
/**
 * Copyright since 2025 InPost S.A.
 *
 * For the full license information, please view the LICENSE file bundled with the module.
 *
 * @author InPost S.A.
 * @copyright since 2025 InPost S.A.
 * @license MIT
 */

declare(strict_types=1);

namespace InPost\International\PickupAddress\Form\Type;

use InPost\International\PickupAddress\Message\CreatePickupAddressCommand;
use InPost\International\PickupAddress\Message\EditPickupAddressCommand;
use PrestaShopBundle\Form\Admin\Type\SwitchType;
use Symfony\Component\Form\AbstractType;
use Symfony\Component\Form\Extension\Core\Type\TextType;
use Symfony\Component\Form\FormBuilderInterface;
use Symfony\Component\Form\FormEvent;
use Symfony\Component\Form\FormEvents;
use Symfony\Component\OptionsResolver\OptionsResolver;
use Symfony\Contracts\Translation\TranslatorInterface;

if (!defined('_PS_VERSION_')) {
    exit;
}

final class PickupAddressType extends AbstractType
{
    /**
     * @var TranslatorInterface
     */
    private $translator;

    public function __construct(TranslatorInterface $translator)
    {
        $this->translator = $translator;
    }

    public function buildForm(FormBuilderInterface $builder, array $options): void
    {
        $builder
            ->add('default', SwitchType::class, [
                'label' => $this->translator->trans('Default', [], 'Modules.Inpostinternational.Admin'),
            ])
            ->add('name', TextType::class, [
                'label' => $this->translator->trans('Name', [], 'Admin.Global'),
            ])
            ->add('contactPerson', ContactPersonType::class, [
                'label' => $this->translator->trans('Contact person', [], 'Modules.Inpostinternational.Address'),
            ])
            ->add('address', AddressType::class, [
                'label' => $this->translator->trans('Address', [], 'Admin.Global'),
            ]);

        if (EditPickupAddressCommand::class !== $options['data_class']) {
            return;
        }

        $builder->addEventListener(FormEvents::PRE_SET_DATA, function (FormEvent $event) {
            $data = $event->getData();

            if (!$data instanceof EditPickupAddressCommand || !$data->isDefault()) {
                return;
            }

            $event->getForm()->add('default', SwitchType::class, [
                'label' => $this->translator->trans('Default', [], 'Modules.Inpostinternational.Admin'),
                'disabled' => true,
            ]);
        });
    }

    public function configureOptions(OptionsResolver $resolver): void
    {
        $resolver->setDefaults([
            'data_class' => CreatePickupAddressCommand::class,
        ]);
    }
}
