<?php
/**
 * Copyright since 2025 InPost S.A.
 *
 * For the full license information, please view the LICENSE file bundled with the module.
 *
 * @author InPost S.A.
 * @copyright since 2025 InPost S.A.
 * @license MIT
 */

declare(strict_types=1);

namespace InPost\International\PickupAddress\Message;

use InPost\International\PickupAddress\DTO\Address;
use InPost\International\PickupAddress\DTO\ContactPerson;
use Symfony\Component\Validator\Constraints as Assert;

if (!defined('_PS_VERSION_')) {
    exit;
}

final class CreatePickupAddressCommand
{
    /**
     * @var string|null
     *
     * @Assert\NotBlank
     * @Assert\Length(max=64)
     */
    private $name;

    /**
     * @var ContactPerson|null
     *
     * @Assert\NotNull
     * @Assert\Valid
     */
    private $contactPerson;

    /**
     * @var Address|null
     *
     * @Assert\NotNull
     * @Assert\Valid
     */
    private $address;

    /**
     * @var bool|null
     *
     * @Assert\NotNull
     */
    private $default = false;

    public function getName(): ?string
    {
        return $this->name;
    }

    public function setName(?string $name): void
    {
        $this->name = $name;
    }

    public function getContactPerson(): ?ContactPerson
    {
        return $this->contactPerson;
    }

    public function setContactPerson(?ContactPerson $contactPerson): void
    {
        $this->contactPerson = $contactPerson;
    }

    public function getAddress(): ?Address
    {
        return $this->address;
    }

    public function setAddress(?Address $address): void
    {
        $this->address = $address;
    }

    public function isDefault(): ?bool
    {
        return $this->default;
    }

    public function setDefault(?bool $default): void
    {
        $this->default = $default;
    }
}
