<?php
/**
 * Copyright since 2025 InPost S.A.
 *
 * For the full license information, please view the LICENSE file bundled with the module.
 *
 * @author InPost S.A.
 * @copyright since 2025 InPost S.A.
 * @license MIT
 */

declare(strict_types=1);

namespace InPost\International\PickupAddress\Message;

if (!defined('_PS_VERSION_')) {
    exit;
}

final class SelectDefaultPickupAddressCommand
{
    /**
     * @var int
     */
    private $addressId;

    public function __construct(int $addressId)
    {
        $this->addressId = $addressId;
    }

    public function getAddressId(): int
    {
        return $this->addressId;
    }
}
