<?php
/**
 * Copyright since 2025 InPost S.A.
 *
 * For the full license information, please view the LICENSE file bundled with the module.
 *
 * @author InPost S.A.
 * @copyright since 2025 InPost S.A.
 * @license MIT
 */

declare(strict_types=1);

namespace InPost\International\PickupAddress;

use Doctrine\Common\Collections\Selectable;
use Doctrine\Persistence\ObjectRepository;
use InPost\International\Entity\PickupAddress;

if (!defined('_PS_VERSION_')) {
    exit;
}

/**
 * @extends ObjectRepository<PickupAddress>
 * @extends Selectable<int, PickupAddress>
 */
interface PickupAddressRepositoryInterface extends ObjectRepository, Selectable
{
    public function add(PickupAddress $address): void;

    public function remove(PickupAddress $address): void;

    public function getDefault(): ?PickupAddress;
}
