<?php
/**
 * Copyright since 2025 InPost S.A.
 *
 * For the full license information, please view the LICENSE file bundled with the module.
 *
 * @author InPost S.A.
 * @copyright since 2025 InPost S.A.
 * @license MIT
 */

declare(strict_types=1);

namespace InPost\International\PickupOrder\DTO;

use Symfony\Component\Validator\Constraints as Assert;

if (!defined('_PS_VERSION_')) {
    exit;
}

final class PickupTime
{
    /**
     * @var \DateTimeImmutable|null
     *
     * @Assert\NotBlank
     */
    private $from;

    /**
     * @var \DateTimeImmutable|null
     *
     * @Assert\NotBlank
     */
    private $to;

    public function __construct(\DateTimeImmutable $from = null, \DateTimeImmutable $to = null)
    {
        $this->from = $from;
        $this->to = $to;
    }

    public function getFrom(): ?\DateTimeImmutable
    {
        return $this->from;
    }

    public function setFrom(?\DateTimeImmutable $from): PickupTime
    {
        $this->from = $from;

        return $this;
    }

    public function getTo(): ?\DateTimeImmutable
    {
        return $this->to;
    }

    public function setTo(?\DateTimeImmutable $to): PickupTime
    {
        $this->to = $to;

        return $this;
    }
}
