<?php
/**
 * Copyright since 2025 InPost S.A.
 *
 * For the full license information, please view the LICENSE file bundled with the module.
 *
 * @author InPost S.A.
 * @copyright since 2025 InPost S.A.
 * @license MIT
 */

declare(strict_types=1);

namespace InPost\International\PickupOrder\Event;

use InPost\International\Entity\PickupOrder;
use InPost\International\EventDispatcher\Event;

if (!defined('_PS_VERSION_')) {
    exit;
}

final class PickupOrderCreatedEvent extends Event
{
    /**
     * @var PickupOrder
     */
    private $pickupOrder;

    public function __construct(PickupOrder $pickupOrder)
    {
        $this->pickupOrder = $pickupOrder;
    }

    public function getPickupOrder(): PickupOrder
    {
        return $this->pickupOrder;
    }
}
