<?php
/**
 * Copyright since 2025 InPost S.A.
 *
 * For the full license information, please view the LICENSE file bundled with the module.
 *
 * @author InPost S.A.
 * @copyright since 2025 InPost S.A.
 * @license MIT
 */

declare(strict_types=1);

namespace InPost\International\PickupOrder\Form;

use InPost\International\PickupOrder\DTO\PickupTime;
use Symfony\Component\Form\AbstractType;
use Symfony\Component\Form\Extension\Core\Type\TimeType;
use Symfony\Component\Form\FormBuilderInterface;
use Symfony\Component\OptionsResolver\OptionsResolver;

if (!defined('_PS_VERSION_')) {
    exit;
}

final class PickupTimeType extends AbstractType
{
    /**
     * @param array{cutoff_time: \DateTimeImmutable|null} $options
     */
    public function buildForm(FormBuilderInterface $builder, array $options): void
    {
        if (null !== $options['cutoff_time']) {
            $hours = range(0, (int) $options['cutoff_time']->format('H'));
        } else {
            $hours = range(0, 23);
        }

        $builder
            ->add('from', TimeType::class, [
                'input' => 'datetime_immutable',
                'hours' => $hours,
                'label' => false,
            ])
            ->add('to', TimeType::class, [
                'input' => 'datetime_immutable',
                'hours' => $hours,
                'label' => false,
            ]);
    }

    public function configureOptions(OptionsResolver $resolver): void
    {
        $resolver
            ->setDefaults([
                'data_class' => PickupTime::class,
                'cutoff_time' => null,
            ])
            ->setAllowedTypes('cutoff_time', ['null', \DateTimeImmutable::class]);
    }
}
