<?php
/**
 * Copyright since 2025 InPost S.A.
 *
 * For the full license information, please view the LICENSE file bundled with the module.
 *
 * @author InPost S.A.
 * @copyright since 2025 InPost S.A.
 * @license MIT
 */

declare(strict_types=1);

namespace InPost\International\PickupOrder\Grid;

use PrestaShop\PrestaShop\Core\Search\Filters;

if (!defined('_PS_VERSION_')) {
    exit;
}

final class PickupOrderFilters extends Filters
{
    protected $filterId = PickupOrderGridDefinitionFactory::GRID_ID;

    public static function getDefaults(): array
    {
        return [
            'limit' => 20,
            'offset' => 0,
            'orderBy' => 'id',
            'sortOrder' => 'DESC',
            'filters' => [],
        ];
    }
}
