<?php
/**
 * Copyright since 2025 InPost S.A.
 *
 * For the full license information, please view the LICENSE file bundled with the module.
 *
 * @author InPost S.A.
 * @copyright since 2025 InPost S.A.
 * @license MIT
 */

declare(strict_types=1);

namespace InPost\International\PickupOrder;

use Doctrine\Bundle\DoctrineBundle\Repository\ServiceEntityRepository;
use Doctrine\Persistence\ManagerRegistry;
use InPost\International\Entity\PickupOrder;

if (!defined('_PS_VERSION_')) {
    exit;
}

/**
 * @extends ServiceEntityRepository<PickupOrder>
 */
final class PickupOrderRepository extends ServiceEntityRepository implements PickupOrderRepositoryInterface
{
    public function __construct(ManagerRegistry $registry)
    {
        parent::__construct($registry, PickupOrder::class);
    }

    public function add(PickupOrder $order, bool $flush = true): void
    {
        $entityManager = $this->getEntityManager();
        $entityManager->persist($order);
        if ($flush) {
            $entityManager->flush();
        }
    }
}
