<?php
/**
 * Copyright since 2025 InPost S.A.
 *
 * For the full license information, please view the LICENSE file bundled with the module.
 *
 * @author InPost S.A.
 * @copyright since 2025 InPost S.A.
 * @license MIT
 */

declare(strict_types=1);

namespace InPost\International\PrestaShop\Grid\Action\Bulk;

use PrestaShop\PrestaShop\Core\Grid\Action\Bulk\AbstractBulkAction;
use Symfony\Component\OptionsResolver\OptionsResolver;

if (!defined('_PS_VERSION_')) {
    exit;
}

/**
 * {@see \PrestaShop\PrestaShop\Core\Grid\Action\Bulk\Type\ModalFormSubmitBulkAction} with an option to customize action button class
 *
 * @internal
 */
final class ModalFormSubmitBulkAction extends AbstractBulkAction
{
    public function getType(): string
    {
        return 'inpost_intl_modal_form_submit';
    }

    protected function configureOptions(OptionsResolver $resolver): void
    {
        $resolver
            ->setDefaults([
                'class' => 'js-bulk-modal-form-submit-btn',
            ])
            ->setRequired([
                'submit_route',
                'modal_id',
            ])
            ->setAllowedTypes('class', 'string')
            ->setAllowedTypes('submit_route', 'string')
            ->setAllowedTypes('modal_id', 'string');
    }
}
