<?php
/**
 * Copyright since 2025 InPost S.A.
 *
 * For the full license information, please view the LICENSE file bundled with the module.
 *
 * @author InPost S.A.
 * @copyright since 2025 InPost S.A.
 * @license MIT
 */

declare(strict_types=1);

namespace InPost\International\PrestaShop\Grid\Model;

if (!defined('_PS_VERSION_')) {
    exit;
}

final class PresentedGrid
{
    /**
     * @var string
     */
    private $id;

    /**
     * @internal construct by denormalizing array data using the Serializer component
     */
    public function __construct(string $id)
    {
        $this->id = $id;
    }

    public function getId(): string
    {
        return $this->id;
    }
}
