<?php
/**
 * Copyright since 2025 InPost S.A.
 *
 * For the full license information, please view the LICENSE file bundled with the module.
 *
 * @author InPost S.A.
 * @copyright since 2025 InPost S.A.
 * @license MIT
 */

declare(strict_types=1);

namespace InPost\International\PrestaShop\Module;

if (!defined('_PS_VERSION_')) {
    exit;
}

class ModuleRepository
{
    /**
     * @template T of \Module
     *
     * @param class-string<T> $name
     *
     * @return T|null
     */
    public function findByName(string $name): ?\Module
    {
        /** @var \Module|false $module */
        $module = \Module::getInstanceByName($name);

        return false === $module ? null : $module;
    }

    public function getIdByName(string $name): ?int
    {
        $id = (int) \Module::getModuleIdByName($name);

        return 0 >= $id ? null : $id;
    }

    public function isEnabled(string $name): bool
    {
        return (bool) \Module::isEnabled($name);
    }
}
