<?php
/**
 * Copyright since 2025 InPost S.A.
 *
 * For the full license information, please view the LICENSE file bundled with the module.
 *
 * @author InPost S.A.
 * @copyright since 2025 InPost S.A.
 * @license MIT
 */

declare(strict_types=1);

namespace InPost\International\PrestaShop\Module\Util;

if (!defined('_PS_VERSION_')) {
    exit;
}

final class ControllerChecker
{
    /**
     * @param string[] $controllerNames
     */
    public static function isModuleController(\FrontControllerCore $controller, string $moduleName, array $controllerNames = []): bool
    {
        if (!$controller instanceof \ModuleFrontControllerCore) {
            return false;
        }

        if ($moduleName !== $controller->module->name) {
            return false;
        }

        if ([] === $controllerNames) {
            return true;
        }

        $controllerName = $controller->page_name;
        $parts = explode('-', $controllerName);
        $controllerName = end($parts);

        return in_array($controllerName, $controllerNames, true);
    }
}
