<?php
/**
 * Copyright since 2025 InPost S.A.
 *
 * For the full license information, please view the LICENSE file bundled with the module.
 *
 * @author InPost S.A.
 * @copyright since 2025 InPost S.A.
 * @license MIT
 */

declare(strict_types=1);

namespace InPost\International\PrestaShop\ObjectModel;

if (!defined('_PS_VERSION_')) {
    exit;
}

interface HydratorInterface
{
    /**
     * @template T of \ObjectModel
     *
     * @param class-string<T> $class
     *
     * @return T
     */
    public function hydrate(array $data, string $class, \ObjectModel $model = null, int $languageId = null): \ObjectModel;

    /**
     * @template T of \ObjectModel
     *
     * @param class-string<T> $class
     *
     * @return T[]
     */
    public function hydrateCollection(array $data, string $class, int $languageId = null): array;
}
