<?php
/**
 * Copyright since 2025 InPost S.A.
 *
 * For the full license information, please view the LICENSE file bundled with the module.
 *
 * @author InPost S.A.
 * @copyright since 2025 InPost S.A.
 * @license MIT
 */

declare(strict_types=1);

namespace InPost\International\PrestaShop\ObjectModel;

use InPost\International\PrestaShop\Database\Connection;
use InPost\International\PrestaShop\ObjectModel\Repository\ObjectRepositoryInterface;

if (!defined('_PS_VERSION_')) {
    exit;
}

interface ObjectManagerInterface
{
    public function getConnection(): Connection;

    public function getHydrator(): HydratorInterface;

    public function save(\ObjectModel $model): void;

    /**
     * @template T of \ObjectModel
     *
     * @param class-string<T> $class
     *
     * @return T|null
     */
    public function find(string $class, int $id, int $languageId = null, int $shopId = null): ?\ObjectModel;

    public function refresh(\ObjectModel $model): void;

    /**
     * @template T of \ObjectModel
     *
     * @param class-string<T> $class
     *
     * @return array<string, mixed> normalized {@see \ObjectModel::$definition}
     */
    public function getMetadata(string $class): array;

    /**
     * @template T of \ObjectModel
     *
     * @param class-string<T> $class
     *
     * @return ObjectRepositoryInterface<T>
     */
    public function getRepository(string $class): ObjectRepositoryInterface;

    /**
     * @template T of \ObjectModel
     *
     * @param class-string<T> $class
     *
     * @return QueryBuilder<T>
     */
    public function createQueryBuilder(string $class, int $languageId = null): QueryBuilder;

    public function remove(\ObjectModel $model): void;
}
